set more off
use /mcr/cps/matched/data/matched.dta, clear

** new lfs coding
*  1  l    LABOR FORCE (L) = EMPLOYED (E) and UNEMPLOYED (U)
*  2  r    RETIRED 
*  3  d    DISABLED
*  4  w    NOT IN LABOR FORCE, WANT JOB
*  5  n    NOT IN LABOR FORCE, other

** create new 5-state lfs variable
cap drop lfs
gen byte lfs = .
replace lfs = 1 if mlr==1 | mlr==2 | mlr==3 | mlr==4
replace lfs = 2 if mlr==5
replace lfs = 3 if mlr==6
replace lfs = 5 if mlr==7 
replace lfs = 4 if mlr==7 & (wantjob==1111 | wantjob==1112 | wantjob==1120 | wantjob==1200)

** compute 5x5 transitions
egen id=group(pid)
xtset id mdate, m
sort id mdate

by id: gen match_12=1 if mvs_4>.834 & L12.mvs_4>.834

cap drop lft
gen lft= 10*L12.lfs+lfs if match_12==1

* collapse to flows
drop if lft == .
collapse (sum) sswgt if match_12==1, by(mdate lft)
gen wgt=sswgt/1000
drop sswgt
drop if lft==-1
reshape wide wgt, i(mdate) j(lft)


forval num1=1/5 {
 gen stock`num1' = 0
  forval num2=1/5 {
   replace stock`num1' = stock`num1' + wgt`num1'`num2' if !missing(wgt`num1'`num2')
  }
}

rename stock1 l  
rename stock2 r
rename stock3 d
rename stock4 w
rename stock5 n

rename wgt1(#) l(#)
rename wgt2(#) r(#)
rename wgt3(#) d(#)
rename wgt4(#) w(#)
rename wgt5(#) n(#)

rename *1 *l
rename *2 *r
rename *3 *d
rename *4 *w
rename *5 *n


tsset mdate, m
format mdate %tm

foreach var in l r d w n{
 foreach var2 in l r d w n{
  gen `var'`var2'_tr = 100*`var'`var2'/`var'
  tssmooth ma `var'`var2'_12 = `var'`var2'_tr ,window(11 1 0)
  label var `var'`var2'_12 "`var'`var2'_12mma"
}
}


* Figure 3
tsline rr_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Retired to Retired, 12mma") 
tsline rl_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Retired to Labor Force, 12mma") 
tsline dd_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Disabled to Disabled, 12mma") 
tsline dl_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Disabled to Labor Force, 12mma") 

* Figure 11a and 11b
tsline wl_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Want a Job to Labor Force, 12mma") 
tsline nl_12 if tin(1998m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Yearly Flows: Do not Want a Job to Labor Force, 12mma") 
